=begin
=基盤システム/エンチャント名




==更新履歴
  Date     Version Author Comment

=end

#==============================================================================
# ■ Game_SystemSwitches
#==============================================================================
class Game_SystemSwitches
  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize
    @data = {}
  end
  #--------------------------------------------------------------------------
  # ● システムスイッチの取得
  #--------------------------------------------------------------------------
  def [](key)
    @data[key] == true
  end
  #--------------------------------------------------------------------------
  # ● システムスイッチの設定
  #     value : ON (true) / OFF (false)
  #--------------------------------------------------------------------------
  def []=(key, value)
    @data[key] = value
    on_change
  end
  #--------------------------------------------------------------------------
  # ● システムスイッチの設定時の処理
  #--------------------------------------------------------------------------
  def on_change
    $game_map.need_refresh = true
  end
end

#==============================================================================
# ■ Game_Interpreter
#==============================================================================
class Game_Interpreter
  #--------------------------------------------------------------------------
  # ● システムスイッチの取得
  #--------------------------------------------------------------------------  
  def ssw(key)
    return $game_system_switches[key]
  end
  #--------------------------------------------------------------------------
  # ● システムスイッチをオン
  #--------------------------------------------------------------------------  
  def on_ssw(key)
    $game_system_switches[key] = true
  end
  #--------------------------------------------------------------------------
  # ● システムスイッチをオフ
  #--------------------------------------------------------------------------  
  def off_ssw(key)
    $game_system_switches[key] = false
  end
  #--------------------------------------------------------------------------
  # ● システムスイッチを反転
  #--------------------------------------------------------------------------  
  def flip_ssw(key)
    $game_system_switches[key] = !$game_system_switches[key]
  end
end




